*******************************************************************************
*                      68000/68010 Grundprogramm ass2                         *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                             Assembler Teil 2                                *
*******************************************************************************


codabcd:
 bsr checkb                     * Nur Byte als Gre
codabcd0:
 bsr checkdn                    * Datenregister am Anfang ?
 bcs.s cod1abcd                 * Nein
 or d5,d6                       * Einbauen
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann mu wieder Datenregister folgen
 bsr errcsyntax                 * Fehlertest
 ror #7,d5                      * An richtige Stelle
 or d6,d5                       * Einbauen
 move d5,d0                     * Nach d0
bra putword                     * Und ausgeben

cod1abcd:
 bsr getea                      * Adressmode ermitteln
 cmp #decre,d4                  * Mu decrement sein
 bsr errnsyntax                 * Sonst Fehler
 and #7,d2                      * Nur %111 brig lassen
 addq #8,d2                     * Und plus 8
 or d2,d6                       * Einbauen
 bsr kommack                    * Komma mu folgen
 bsr getea                      * Dann wieder Adressmode feststellen
 cmp #decre,d4                  * Mu auch decrement sein
 bsr errnsyntax                 * Sonst Fehler
 and #7,d2                      * Nummer des Datenregisters
 ror #7,d2                      * An richtige Stelle
 or d6,d2                       * Einbauen
 move d2,d0                     * Nach d0
bra putword                     * Und ausgeben

codand:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Folgt '#' ?
 bne.s cod1and                  * Nein
 move attcode(a5),d6            * Es ist andi
bra codeori0                    * Wie codeori behandeln

cod1and:
 bsr checkdn                    * Folgt Datenregister ?
 bcc.s codanaadd                * Ja, dann weiter
cod2and:
 bsr getea                      * Sonst Adressmode holen
 and #areg,d4                   * Adressregister direkt
 bsr errnadress                 * ist nicht erlaubt
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann mu Datenregister folgen
 bsr errcsyntax                 * Sonst Fehler
 bsr sizeudn                    * Size und Register einbauen
bra codea                       * Und ausgeben

codadd:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Folgt '#', dann addi
 bne.s codadd1
 move attcode(a5),d6            * Alternativbefehl
bra codaddi0                    * Wie addi behandeln

codadd1:
 bsr checkdn                    * Datenregister am Anfang ?
 bcs.s codadd3                  * Nein, weiter
codanaadd:
 ror #7,d5                      * Registernummer an richtige Stelle
 move wordbyte(a5),d0           * Gre holen
 addq #4,d0
 rol #6,d0                      * An richtige Stelle
 or d0,d6                       * Einbauen
 or d5,d6                       * Einbauen
 bsr kommack                    * Komma mu folgen
 bsr getea                      * Adressmode holen
 cmp #dreg,d4                   * Ist es Datenregister direkt ?
 beq.s codadd2                  * Ja, dann weiter
 and #areg!pcadr,d4             * Adressregister direkt und PC nicht als
 bsr errnadress                 * Zieladresse erlaubt
bra codea                       * Ausgeben

codadd2:
 and #%1111111011111111,d6      * Nur ein Bit lschen
 move d6,d0                     * Nach d0
 and #%0000111000000000,d0      * Nur drei Bit lassen
 rol #7,d0                      * An richtige Stelle
 or d6,d0                       * Zusammensetzen
 and #%1111000111111111,d0      * Drei Bits lschen
 and #7,d2                      * Datenregisternummer
 ror #7,d2                      * An richtige Stelle
 or d2,d0                       * Einbauen
bra putword                     * Ausgeben

codadd3:
 bsr getea                      * Adressmode ermitteln
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann mu Datenregister folgen
 bsr errcsyntax                 * Sonst Fehler
 bsr sizeudn                    * Size und Register einbauen
bra codea                       * Und ausgeben

codadda:
 bsr checkwl                    * Nur Wort oder Langwort
 bsr immeck                     * '#' am Anfang ?
 bcs.s codadda2                 * Nein, dann weiter
 bsr expr1                      * Arithmetischen Ausdruck auswerten
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Dann mu Adressregister folgen
 bsr errcsyntax                 * Sonst Fehler
 exg d0,d5                      * d0 und d5 vertauschen
 rol #2,d0                      * Nummer des Registers an richtige Stelle
 or wordbyte(a5),d0             * Gre einbauen
 rol #7,d0                      * An richtige Stelle
 or d6,d0                       * d6 einfgen
 or #%111100,d0                 * Mode einsetzen
 bsr putword                    * Und ausgeben
 cmp #2,wordbyte(a5)            * Langwort ?
 beq.s codadda1                 * Ja, dann weiter
 move.l d5,d0                   * d5 nach d0
 bsr rangewck                   * Bereichstest
bra putword                     * Wort ausgeben

codadda1:
 move.l d5,d0                   * d5 nach d0
bra putlong                     * Ausgeben

codadda2:
 bsr getea                      * Adressmode ermitteln
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Dann Adressregister
 bsr errcsyntax                 * Sonst Fehler
 rol #2,d5                      * Nummer Register an richtige Stelle
 or wordbyte(a5),d5             * Gre einsetzen
 rol #7,d5                      * An richtige Stelle
 or d5,d6                       * Einbauen
bra codea                       * Ausgeben

codaddi:
 bsr checkbwl                   * Alle Gren erlaubt
codaddi0:
 bsr.s sizeein                  * Gre an richtige Stelle
 bsr immeck                     * '#' mu folgen
 bsr errcsyntax                 * Sonst Fehler
 bsr expr1                      * Arithmetischen Ausdruck auswerten
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 bsr getea                      * Effektive Adresse holen
codeoaddi:
 and #areg!pcadr,d4             * Adressregister direkt und PC sind
 bsr errnadress                 * nicht erlaubt
 bsr putorea                    * Adressmode verknpft mit Befehl ausgeben
 move.l d0,d6
 move.l (a7)+,d0
 cmp #1,wordbyte(a5)            * Wort ?
 beq.s codaddi1                 * Ja, weiter
 cmp #2,wordbyte(a5)            * Langwort ?
 beq.s codaddi2                 * Ja, weiter
 and #$ff,d0                    * Nur Byte-Gre

codaddi1:
 bsr putword                    * Wort ausgeben
 move.l d6,d0
bra putea                       * Zieladressmode

codaddi2:
 bsr putlong                    * Langwort ausgeben
 move.l d6,d0
bra putea                       * Zieladressmode

sizeudn:                        * Size und Register einbauen
 ror #7,d5
 or d5,d6                       * Register an richtiger Stelle einbauen
sizeein:                        * Size einbauen
 move wordbyte(a5),d7           * Gre holen
 rol #6,d7                      * An richtige Stelle
 or d7,d6                       * Mit Befehlscode verknpfen
rts

codaddq:
 bsr checkbwl                   * Alle Gren erlaubt
 movea.l a0,a4                  * a0 merken
 bsr.s sizeein                  * Gre an richtige Stelle
 bsr immeck                     * '#' mu  folgen
 bsr errcsyntax                 * Sonst Fehler
 bsr expr1                      * Wert holen
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 bsr getea                      * Adressmode holen
 and #pcadr,d4                  * PC ist als Ziel nicht
 bsr errnadress                 * erlaubt
 cmp #areg,d4                   * Adressregister als Ziel ?
 bne.s codaddq0                 * Nein, dann weiter
 exg.l a0,a4                    * Alte Position
 tst wordbyte(a5)               * Byte als Gre ?
 bsr erresize                   * Ja, dann Fehler
 exg.l a0,a4
codaddq0:
 move.l (a7)+,d5
 cmp #2,passflag(a5)            * Beim zweiten Durchgang
 bne.s codaddq1                 * Bereichstest des Wertes
 move.l d5,d4
 subq.l #1,d4                   * Bereich 1 bis
 and.l #$fffffff8,d4            * 8 ist erlaubt
 bsr errnber                    * Sonst Fehlerausgabe
codaddq1:
 ror #7,d5                      * Wert an richtige Stelle
 and #$0e00,d5                  * Nur 3 Bits ( 8 ist 0 )
 or d5,d6                       * Verknpfen mit Befehlscode
bra codea                       * Und ausgeben

codaddx:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr sizeein                    * Gre an richtige Stelle
bra codabcd0                    * Wie abcd behandeln

codshift:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 movea.l a0,a4                  * a0 merken
 cmp.b #'#',(a0)                * Jetzt knnte '#' folgen
 beq.s codsh1
 bsr getea                      * Adressmode holen
 cmp #dreg,d4                   * Ist es Datenregister direkt ?
 bne.s codsh2                   * Nein
 bsr kommack                    * Ja, dann mu Komma folgen
 bsr sizeein                    * Gre einbauen
 and #7,d2
 ror #7,d2
 or #%100000,d2                 * Bit einsetzen
 move d2,d0                     * Nach d0
bra.s codsh1a                   * Weiter wie unten

codsh1:
 bsr sizeein                    * Gre einbauen
 addq.l #1,a0                   * '#' berspringen
 bsr expr1                      * Wert ermitteln
 subq.l #1,d0                   * Bereich 1 bis 8
 bsr range07                    * Bereich Null bis Sieben testen
 addq.l #1,d0                   * Jetzt wieder 0..8
 and #7,d0                      * Nur 0..7 erlaubt (8 wird zu Null)
 ror #7,d0                      * An richtige Stelle
 bsr kommack                    * Komma mu folgen
codsh1a:
 bsr checkdn                    * Dann mu Datenregister kommen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 or d6,d0                       * Befehlscode dazu
 or d5,d0                       * Zusammensetzen
bra putword                     * Und ausgeben

codsh2:
 and #areg!dreg!pcadr,d4        * Adress- und Datenregister direkt sowie
 bsr errnadress                 * PC sind nicht erlaubt
 exg.l a0,a4
 cmp #1,wordbyte(a5)            * Gre mu Wort sein
 bsr errnsize                   * Sonst Fehler
 exg.l a0,a4
 move attcode(a5),d6            * Alternativcode
bra codea                       * Mit Adressmode verknpfen und ausgeben

codbtst:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Es knnte '#' folgen
 bne.s codbtst1                 * Nein, dann weiter
 addq.l #1,a0                   * '#' auslassen
 move attcode(a5),d6            * Alternativcode
 bsr expr1                      * Wert holen
 bsr rangebck                   * Bereichstest
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 bsr getea                      * Zieladresse bestimmen
 move.l (a7)+,d5
 and #areg,d4                   * Adressregister direkt ist als Ziel nicht
 bsr errnadress                 * erlaubt
 bsr putorea                    * Befehlscode ausgeben
 move.l d0,-(a7)
 move d5,d0
 and #$1f,d0
 bsr putword                    * Bitnummer ausgeben
 move.l (a7)+,d0
bra putea                       * Zieladressmode ausgeben

codbtst1:
 bsr checkdn                    * Bitnummer im Datenregister
 bsr errcsyntax                 * Kein Datenregister also Fehler
 ror #7,d5                      * Nummer an richtige Stelle
 or d5,d6
 bsr kommack                    * Komma mu folgen
 bsr getea                      * Zieladresse holen
 and #areg,d4                   * Adressregister direkt ist nicht erlaubt
 bsr errnadress                 * Fehler
bra codea                       * Ausgabe

codbchg:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Es knnte '#' folgen
 bne.s codbchg1                 * Nein, dann weiter
 addq.l #1,a0                   * '#' berspringen
 move attcode(a5),d6            * Alternativcode
 bsr expr1                      * Wert holen
 bsr rangebck                   * Bereichstest
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 bsr getea                      * Zieladressmode holen
 move.l (a7)+,d5
 and #areg!pcadr,d4             * Adressregister direkt und PC relativ sind
 bsr errnadress                 * als Ziel nicht zugelassen
 bsr putorea                    * Verknpfen Ausgabe
 move.l d0,-(a7)
 move d5,d0
 and #$1f,d0
 bsr putword                    * Ausgabe der Bits
 move.l (a7)+,d0
bra putea                       * Ausgabe der Zieladresse

codbchg1:
 bsr checkdn                    * Adressregister mu folgen
 bsr errcsyntax                 * Fehlertest
 ror #7,d5
 or d5,d6
 bsr kommack                    * Komma mu folgen
bra codtas1                     * Weiter wie TAS

codbra:
 bsr checkbw                    * Nur Byte oder Wort
 tst wordbyte(a5)               * Wenn Wort, dann weiter
 bne.s codbra1
 bsr expr1                      * Wert berechnen
 sub.l pcstand(a5),d0           * Relativen Sprung berechnen
 subq.l #2,d0                   * Vom Zeilenanfang an berechnen
 bsr rangeb1ck                  * Bereich -128 bis +128
 and #$ff,d0                    * Nur Byte-Gre (Auch negativ)
 bsr erreber                    * Der Sprung darf nicht den Abstand Null haben
 or d6,d0                       * Mit Befehlscode zusammensetzen
bra putword                     * Und ausgeben

codbra1:
 move d6,d0                     * Befehlscode
 bsr putword                    * Ausgeben
 bsr expr1                      * Adressabstand holen
 sub.l pcstand(a5),d0           * Relativen Sprung berechnen
 bsr rangew1ck                  * Bereich prfen
bra putword                     * Und ausgeben

codchk:
 bsr checkw                     * Nur Wort
bra.s codmuls0

codmuls:
 bsr checkno                    * Keine Grenangabe erlaubt
codmuls0:
 bsr immeck                     * '#' kann am Anfang stehen
 bcs.s codmuls1                 * Nein, dann weiter
 bsr expr1                      * Wert holen
 bsr rangewck                   * Mu im Wort-Bereich liegen
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann mu Datenregister folgen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 ror #7,d5                      * Nummer des Datenregisters an richtige Stelle
 or d6,d5                       * Mit Befehlscode verknpfen
 or #%111100,d5
 exg d0,d5
 bsr putword                    * Befehlscode ausgeben
 move d5,d0
bra putword                     * Wert ausgeben

codmuls1:
 bsr getea                      * Effektive Adresse holen
 and #areg,d4                   * Adressregister direkt nicht erlaubt
 bsr errnadress
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann Datenregister
 bsr errcsyntax                 * Sonst Fehler
 ror #7,d5                      * Nummer an richtige Stelle
 or d5,d6
bra codea                       * Ausgabe

codcmp:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * '#' kann folgen
 bne.s codcmp1
 addq.l #1,a0
 move attcode(a5),d6            * Alternativcode
 bsr sizeein                    * Gre an richtige Stelle
 bsr expr1                      * Arithmetischen Ausdruck auswerten
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 bsr getea                      * Effektive Adresse holen
 and #areg,d4                   * Adressregister direkt ist nicht erlaubt
 bsr errnadress
 bsr putorea                    * Adressmode verknpft mit Befehl ausgeben
 move.l d0,d6
 move.l (a7)+,d0
 cmp #1,wordbyte(a5)            * Wort ?
 beq codaddi1                   * Ja, weiter
 cmp #2,wordbyte(a5)            * Langwort ?
 beq codaddi2                   * Ja, weiter
 and #$ff,d0                    * Nur Byte-Gre
bra codaddi1

codcmp1:
 bsr getea                      * Adressmode Quelle holen
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann Datenregister
 bsr errcsyntax                 * Sonst Fehler
 bsr sizeudn                    * Size und Register einbauen
bra codea                       * Ausgabe

codcmpm:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr sizeein                    * Gre an richtige Stelle
 bsr getea                      * Adressmode holen
 cmp #incre,d4                  * Nur -(an) ist erlaubt
 bsr errnsyntax                 * Sonst Fehler
 and #7,d2                      * Nur Nummer des Register briglassen
 or d2,d6                       * Einbauen
 bsr kommack                    * Komma mu folgen
 bsr getea                      * Zieladressmode holen
 cmp #incre,d4                  * Mu auch -(am) sein
 bsr errnsyntax                 * Sonst Fehler
 and #7,d2                      * Nur Nummer Register lassen
 ror #7,d2                      * Einbauen
 or d6,d2                       * Zusammensetzen
 move d2,d0                     * Nach d0
bra putword                     * Ausgeben

coddbcc:
 bsr checkw                     * Nur Wort als Gre
 bsr checkdn                    * Datenregister mu am Anfang sein
 bsr errcsyntax                 * Sonst Fehler
 bsr kommack                    * Komma mu folgen
 move d6,d0                     * Befehlscode
 or d5,d0                       * Verknpft mit Nummer des Registers
 bsr putword                    * Ausgabe
 bsr expr1                      * Wert holen
 sub.l pcstand(a5),d0           * Relative Adresse berechnen
 bsr rangew1ck                  * Mu im Wort-Bereich sein
bra putword                     * Ausgabe

codeor:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Wenn '#' am Anfang, dann wie eori
 bne.s codeor1
 move attcode(a5),d6            * Alternativcode
bra.s codeori0

codeor1:
 bsr checkdn                    * Nicht '#', dann mu Datenregister kommen
 bsr errcsyntax                 * Fehler
 bsr sizeudn                    * Size und Register einbauen
 bsr kommack                    * Komma mu folgen
bra codtas1                     * Weiter wie TAS

codeori:
 bsr checkbwl                   * Alle Gren erlaubt
codeori0:
 movea.l a0,a4
 bsr immeck                     * '#' mu am Anfang stehen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 bsr expr1                      * Wert holen
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 move.l a0,-(a7)
 bsr setigname                  * Namen ermitteln
 bcs.s codeori2                 * Fehler, dann weiter
 cmp.l #'CCR ',d2
 beq.s codeori1                 * eori to CCR
 cmp.l #'SR  ',d2
 bne.s codeori2
 exg.l a0,a4
 cmp #1,wordbyte(a5)            * Als Gre nur Wort erlaubt
 bsr errnsize
 exg.l a0,a4
 move d6,d0                     * eori to SR
 or #%01111100,d0               * Befehlscode
 bsr putword                    * Ausgabe
 addq.l #4,a7                   * Stack reinigen
 move.l (a7)+,d0
 bsr rangewck                   * Bereichstest
bra putword                     * Ausgabe

codeori1:
 move d6,d0                     * eori to CCR
 or #%00111100,d0
 bsr putword                    * Ausgabe
 addq.l #4,a7                   * Stack reinigen
 move.l (a7)+,d0
 bsr rangebck                   * Bereichstest
bra putword                     * Ausgabe

codeori2:
 bsr sizeein                    * Gre holen
 movea.l (a7)+,a0
 bsr getea                      * Zieladressmode holen
 and #areg!pcadr,d4             * Adressregister direkt und PC sind
 bsr errnadress                 * nicht erlaubt
bra codeoaddi                   * Wie addi behandeln

codexg:
 bsr checkl                     * Nur Langwort
 bsr checkdn                    * Adressregister am Anfang ?
 bcs.s codexg2                  * Nein, weiter
 move d5,d0
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann Datenregister ?
 bcs.s codexg1                  * Nein, weiter
 moveq #%01000000,d7            * Austausch Dn, Dm
bra.s codexg4

codexg1:
 bsr checkan                    * Adressregister mu folgen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 move #%10001000,d7             * Austausch Dn, Am
bra.s codexg4

codexg2:
 bsr checkan                    * Adressregister mu am Anfang stehen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 move d5,d0                     * Nummer merken
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Folgt Datenregister ?
 bcs.s codexg3                  * Nein, dann weiter
 ror #7,d5                      * An richtige Stelle
 move #%10001000,d7             * Austausch An, Dm
bra.s codexg5

codexg3:
 bsr checkan                    * Adressregister mu folgen
 bsr errcsyntax                 * Fehler
 moveq #%01001000,d7            * Austausch An, Am
codexg4:
 ror #7,d0                      * An richtig Stelle
codexg5:
 or d5,d0                       * Zusammensetzen
 or d6,d0                       * Zusammensetzen
 or d7,d0                       * Austausch-Art
bra putword                     * Ausgabe

codext:
 bsr checkwl                    * Nur Wort oder Langwort
 bsr checkdn                    * Datenregister mu am Anfang stehen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 or d6,d5                       * Nummer Datenregister einbauen
 cmp #2,wordbyte(a5)
 beq.s codext1                  * Erweiterung auf Langwort
 cmp #1,wordbyte(a5)            * Erweiterung auf Wort ?
 bsr errnsize                   * Nein, dann Fehler
 or #%10000000,d5               * Gre
 move d5,d0                     * Nach d0
bra putword                     * Ausgabe

codext1:
 or #%011000000,d5              * Gre
 move d5,d0                     * Nach d0
bra putword                     * Ausgabe

codall:
 bsr checkno                    * Keine Grenangabe erlaubt
 move d6,d0                     * Code einfach nach d0
bra putword                     * Ausgabe

codtas:
 bsr checkb                     * Nur Byte
codtas1:                        * Einsprung fr andere Befehle
 bsr getea                      * Zieladressmode holen
 and #areg!pcadr,d4             * Adressregister direkt und PC sind als Ziel
 bsr errnadress                 * Nicht erlaubt
bra codea                       * Ausgabe

codpea:
 bsr checkl                     * Nur Langwort erlaubt
bra.s codjmp1

codjmp:
 bsr checkno                    * Keine Grenangabe erlaubt
codjmp1:
 bsr getea                      * Zieladressmode holen
 and #decre!incre!areg!dreg,d4  * (An)+ / -(An) / An und Dn-Adressierungen sind
 bsr errnadress                 * nicht erlaubt
bra codea                       * Ausgabe

codlea:
 bsr checkl                     * Nur Langwort erlaubt
 bsr getea                      * Quelladressmode holen
 and #areg!dreg!incre!decre,d4  * Nicht erlaubte Adressierungsarten
 bsr errnadress                 * Fehler
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Adressregister mu folgen
 bsr errcsyntax                 * Fehler
 ror #7,d5                      * Nummer an richtige Stelle
 or d5,d6                       * Zusammensetzen
bra codea                       * Ausgabe

codlink:
 bsr checkw                     * Nur Wort erlaubt
 bsr checkan                    * Adressregister mu am Anfang stehen
 bsr errcsyntax                 * Fehler
 or d6,d5                       * Nummer einbauen
 move d5,d0
 bsr putword                    * Ausgabe
 bsr kommack                    * Komma mu folgen
 bsr immeck                     * '#' mu folgen
 bsr errcsyntax                 * Fehler
 bsr expr1                      * Wert holen
 bsr rangewck                   * Mu Wort-Bereich sein
bra putword                     * Ausgabe

codmovea:
 bsr checkwl                    * Nur Wort oder Langwort
 bsr immeck                     * '#' am Anfang ?
 bcc.s codma1                   * Ja, dann weiter
 bsr getea                      * Adressmode holen
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Dann mu Adressregister kommen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 ror #3,d5
 or wordbyte(a5),d5             * Gre einbauen
 ror #4,d5                      * An richtige Stelle
 or d5,d6                       * Mit Befehl verknpfen
bra codea                       * Ausgabe

codma1:
 bsr expr1                      * Wert holen
 movea.l a0,a4
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Adressregister mu folgen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 ror #3,d5
 move wordbyte(a5),d4           * Gre holen
 bsr erresize                   * Byte ist nicht erlaubt
 or d4,d5                       * Nummer des Adressregisters einbauen
 ror #4,d5                      * Schieben
 or #%111100,d5                 * Mode
 or d5,d6
 exg d0,d6
 bsr putword                    * Ausgabe Befehlscode
 exg d0,d6
 cmp #1,wordbyte(a5)
 bne putlong                    * Langwort-Konstante
 bsr rangewck                   * Bereichstest Wort
bra putword                     * Ausgabe Wort

codmove:
 bsr checkbwl                   * Alle Gren erlaubt
 movea.l a0,a4
 bsr setigname                  * Namen holen
 bcs.s codmove1                 * Fehler, dann weiter
 cmp.l #'SR  ',d2               * move from SR ?
 beq codmosr                    * Ja
 cmp.l #'USP ',d2               * move from USP ?
 beq codmousp                   * Ja
 cmp.l #'CCR ',d2               * move from CCR ?
 beq codmoccr                   * Ja
codmove1:
 movea.l a4,a0                  * a0 zurck
 bsr immeck                     * '#' am Anfang ?
 bcc codmoda                    * Ja, dann weiter
 bsr getea                      * Quelladressmode holen
 bsr kommack                    * Komma mu folgen
 movem.l d0/d2/d3,-(a7)
 move.l a0,-(a7)
 bsr setigname                  * Namen holen
 bcs.s codmove2                 * Fehler, dann weiter
 cmp.l #'SR  ',d2               * move to SR ?
 beq.s codsrmo                  * Ja
 cmp.l #'CCR ',d2               * move to CCR ?
 beq.s codccrmo                 * Ja
 cmp.l #'USP ',d2               * move to USP ?
 beq coduspmo                   * Ja
codmove2:
 movea.l (a7)+,a0
 bsr getea                      * Zieladressmode holen
 and #areg!pcadr,d4             * Adressregister direkt und PC sind
 bsr errnadress                 * nicht erlaubt
 move wordbyte(a5),d6           * Gre holen
 addq #1,d6                     * 1 addieren
 cmp #1,d6                      * Wenn 1
 beq.s codmove3                 * dann OK
 eori #1,d6                     * Sonst Bit Null ndern
codmove3:
 rol #3,d6                      * An richtige Stelle
 move d2,d1
 and #7,d1                      * Quelladressmode
 or d1,d6                       * Einbauen
 rol #3,d6
 move d2,d1
 ror #3,d1
 and #7,d1
 or d1,d6                       * Zusammensetzen
 rol #6,d6                      * An richtige Stelle
 move.l d0,d1                  * Werte merken
 move d2,d4
 move d3,d7
 movem.l (a7)+,d0/d2/d3
 bsr putorea
 move d7,d6                     * d7 wird zerstrt aber d6 ist jetzt frei
 bsr putea                      * Ausgabe Erweiterungen
 move.l d1,d0                   * Werte zurck
 move d4,d2
 move d6,d3
bra putea                       * Ausgabe Zielcode

codsrmo:
 addq.l #4,a7                   * Stack reinigen
 move #$46c0,d6                 * Code
 movem.l (a7)+,d0/d2/d3
 and #areg,d4                   * Adressregister direkt nicht als Ziel erlaubt
 bsr errnsyntax                 * Fehler
bra codea                       * Ausgabe

codccrmo:
 addq.l #4,a7                   * Stack reinigen
 move #$44c0,d6                 * Code
 movem.l (a7)+,d0/d2/d3
 and #areg,d4                   * Adressregister direkt nicht als Ziel erlaubt
 bsr errnsyntax                 * Fehler
bra codea                       * Ausgabe

coduspmo:
 addq.l #4,a7                   * Stack reinigen
 movem.l (a7)+,d0/d2/d3
 cmp #areg,d4                   * Nur als Ziel erlaubt
 bsr errnsyntax                 * Fehler
 move d2,d0
 and #7,d0
 or #$4e60,d0
bra putword                     * Ausgabe

codmosr:
 bsr kommack                    * Komma mu folgen
 move #$40c0,d6
bra codtas1                     * Weiter wie TAS

codmousp:
 bsr kommack                    * Komma mu folgen
 bsr checkan                    * Nur Adressregister als Ziel erlaubt
 bsr errcsyntax                 * Fehler
 move #$4e68,d0                 * Code fr move to usp
 or d5,d0                       * Verknpfen
bra putword                     * Ausgabe

codmoccr:
 bsr kommack                    * Komma mu folgen
 move #$42c0,d6
bra codtas1                     * Weiter wie TAS

codmoda:
 bsr expr1                      * Wert holen
 movea.l a0,a1                  * Adresse merken fr Fehleranzeige
 bsr kommack                    * Komma mu folgen
 move.l d0,-(a7)
 move.l a0,-(a7)
 bsr setigname                  * Namen holen
 bcs.s codmoda1                 * Fehler, dann weiter
 cmp.l #'CCR ',d2               * move to CCR ?
 beq codmdaccr                  * Ja
 cmp.l #'SR  ',d2               * move to SR ?
 beq codmdasr                   * Ja
codmoda1:
 movea.l (a7)+,a0
 bsr getea                      * Zieladressmode holen
 move.l (a7)+,d5
 and #areg!pcadr,d4             * Als Ziel nicht erlaubt
 bsr errnadress                 * Fehler
 move.l d0,-(a7)
 move wordbyte(a5),d0           * Gre wandeln
 addq #1,d0
 cmp #1,d0
 beq.s codmoda2
 eori #1,d0
codmoda2:
 rol #3,d0                      * Alles zusammensetzen
 move d2,d7
 and #7,d7
 or d7,d0
 rol #3,d0
 move d2,d7
 ror #3,d7
 and #7,d7
 or d7,d0
 rol #6,d0
 or #%111100,d0
 bsr putword                    * Ausgabe Befehlscode
 exg.l a0,a1                    * Adresse Datenwert mit Adresse Zeile tauschen
 move wordbyte(a5),d0
 beq.s codmoda4
 cmp #1,d0
 beq.s codmoda3
 move.l d5,d0                   * Konstante ist Langwort
 bsr putlong                    * Ausgabe
bra.s codmoda5
codmoda3:
 move.l d5,d0                   * Konstante ist Wort
 bsr rangewck                   * Bereichstest
 bsr putword                    * Ausgabe
bra.s codmoda5
codmoda4:
 move.l d5,d0                   * Konstante ist Byte
 bsr rangebck                   * Bereichstest
 and #$ff,d0                    * Nur Byte
 bsr putword                    * Ausgabe
codmoda5:
 exg.l a0,a1                    * Adressregister zurck tauschen
 move.l (a7)+,d0
bra putea                       * Ausgabe Erweiterung

codmdaccr:
 addq.l #4,a7                   * Stack reinigen
 move #$44fc,d0                 * Code fr move to ccr
 bsr putword                    * Ausgabe
 move.l (a7)+,d0
 bsr rangewck                   * Bereichtstest
bra putword                     * Ausgabe

codmdasr:
 addq.l #4,a7                   * Stack reinigen
 move #$46fc,d0                 * Code fr move to sr
 bsr putword                    * Ausgabe
 move.l (a7)+,d0
 bsr rangewck                   * Bereichstest
bra putword                     * Ausgabe

codmovec:
 bsr checkl                     * Nur Langwort
 bsr igbn
 bsr.s getadda                  * Adressregister oder Datenregister ?
 bcc.s codmovc0
 move d6,d0
 bsr putword                    * Erstes Wort ausgeben
 bsr.s getrc                    * Controlregister holen
 bsr kommack                    * Komma mu folgen
 bsr.s getadda                  * Register holen
 bsr errcsyntax                 * Fehler, wenn nicht Register
 or d5,d6
 move d6,d0
bra putword                     * Ausgabe zweites Wort

codmovc0:
 or #1,d6                       * Richtung
 move d6,d0
 bsr putword                    * Erstes Wort ausgeben
 bsr kommack                    * Komma mu folgen
 bsr.s getrc                    * Controlregister holen
 or d5,d6
 move d6,d0
bra putword                     * Ausgabe zweites Wort

getrc:                          * Ergebnis in d6
 bsr setigname                  * Namen holen
 lea getrctab(pc),a3            * Tabelle der Register
 moveq #4-1,d7
getrclp:
 cmp.l (a3)+,d2                 * Vergleich
 beq.s getrc1                   * OK, Register gefunden
 addq.l #2,a3                   * Nicht gefunden
dbra d7,getrclp                 * Weiter suchen
bra errs1                       * Fehler, da nicht gefunden
getrc1:
 move (a3),d6                   * Code fr Register
rts

getrctab:
 dc.b 'SFC ',$00,$00
 dc.b 'DFC ',$00,$01
 dc.b 'USP ',$08,$00
 dc.b 'VBR ',$08,$01

getadda:                        * Liefert in d5 Code fr Register
 bsr igbn                       * Carry, wenn kein Register
 bsr checkdn
 bcc.s getadda1                 * OK, Datenregister
 bsr checkan
 bcc.s getadda0                 * OK, Adressregister
 clr d5
bra carset                      * Fehler
getadda0:
 or #8,d5                       * Bit fr Adressregister
getadda1:
 ror #4,d5                      * An richtige Stelle
bra carres                      * OK

codmovem:
 bsr checkwl                    * Als Gre nur Wort oder Langwort
 bsr igbn                       * Leerzeichen ignorieren
 movea.l a0,a4                  * Adresse merken
 bsr checkdn                    * Dn am Anfang ?
 bcc.s codmom1                  * Ja, dann OK
 bsr checkan                    * An am Anfang ?
 bcs.s codmom4                  * Nein, dann weiter
codmom1:                        * movem dn-an,<ea>
 movea.l a4,a0                  * Adresse zurck
 bsr.s getregli                 * Liste der Register holen
 bsr kommack                    * Komma mu folgen
 move d4,-(a7)
 bsr getea                      * Adressmode holen
 move (a7)+,d5
 cmp #decre,d4                  * Wenn Decrement, dann
 bne.s codmom2
 bsr revlist                    * Liste umdrehen
codmom2:
 and #dreg!areg!incre!pcadr,d4  * Nicht erlaubte Adressmodi
 bsr errnadress                 * Fehler
 cmp #1,wordbyte(a5)            * Wort ?
 beq.s codmom3                  * Ja, dann OK
 or #%1000000,d6                * Gre Langwort einstellen
codmom3:
 bsr putorea                    * Ausgabe Befehlscode
 exg d0,d5
 bsr putword                    * Ausgabe Bits fr Registerfolge
 exg d0,d5
bra putea                       * Ausgabe Erweiterung, wenn vorhanden

codmom4:                        * movem <ea>,Reglist
 movea.l a4,a0                  * Adresse zurck
 bsr getea                      * Adressmode holen
 and #dreg!areg!decre,d4        * Nicht erlaubte Adressierungsarten
 bsr errnadress                 * Fehler
 bsr kommack                    * Komma mu folgen
 bsr.s getregli                 * Registerliste holen
 or #$400,d6                    * Richtung
 tst wordbyte(a5)               * Byte ist als Gre
 bsr erresize                   * nicht erlaubt
 cmp #1,wordbyte(a5)            * Wort-Gre ?
 beq.s codmom5                  * Ja, dann OK
 or #%1000000,d6                * Sonst Langwort-Bit setzen
codmom5:
 bsr putorea                    * Ausgabe Befehlscode
 exg d4,d0
 bsr putword                    * Ausgabe Registerliste
 exg d4,d0
bra putea                       * Eventuell Ausgabe Erweiterung

getregli:
 moveq #0,d4                    * Registerliste holen
 movem.l d0/d5,-(a7)
 bsr.s getregl2                 * Liste holen
 movem.l (a7)+,d0/d5
 bcs errs1                      * Wenn Carry gesetzt, dann Syntax-Fehler
rts

getregl1:
 addq.l #1,a0                   * a0 erhhen
getregl2:
 bsr checkdn                    * Anfang mit dn ?
 bcs.s getregl5                 * Nein, dann weiter
 bset d5,d4                     * Bit fr das spezielle Register setzen
 bsr igbn                       * Leerzeichen ignorieren
getregl3:
 cmp.b #'/',(a0)                * Folgt '/' ?
 beq.s getregl1                 * Ja, dann nur ein Register
 cmp.b #'-',(a0)                * folgt '-' ?
 bne carres                     * Nein, dann OK
 addq.l #1,a0                   * a0 erhhen
 move d5,d0                     * d5 merken
 bsr checkdn                    * Nummer holen
 bcs carset                     * Fehler, da kein Datenregister folgt
getregl4:
 cmp d0,d5                      * d0 gleich d5
 beq.s getregl3                 * Dann alle Register gesetzt
 addq #1,d0                     * Sonst erhhen
 bset d0,d4                     * Und setzen
bra.s getregl4

getregl5:
 bsr checkan                    * Folgt an ?
 bcs carset                     * nein, dann Fehler
 addq #8,d5                     * d5+8, damit richtige Bits gesetzt werden
 bset d5,d4                     * Setzen
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'/',(a0)                * Folgt '/' ?
 beq.s getregl1                 * Nein, dann normal weiter
 cmp.b #'-',(a0)                * Folgt '-' ?
 bne carres                     * Nein, dann Ende
 addq.l #1,a0                   * a0 erhhen
 move d5,d0                     * d5 merken
 bsr checkan                    * Adressregister mu folgen
 bcs carset                     * Sonst Fehlerausgabe
 addq #8,d5                     * d5 erhhen, damit richtige Bits gesetzt werden
getregl6:
 cmp d0,d5                      * d0 gleich d5
 beq.s getregl3                 * Ja, dann OK
 addq #1,d0                     * Sonst erhhen
 bset d0,d4                     * Und Bit setzen
bra.s getregl6

revlist:                        * Liste umdrehen
 movem.l d1/d2,-(a7)            * Ntig bei spezieller Adressierungsart
 moveq #16-1,d2                 * 16 Bits
revlist1:
 roxl #1,d5                     * Von links holen
 roxr #1,d1                     * Nach rechts schieben
dbra d2,revlist1
 move d1,d5
 movem.l (a7)+,d1/d2            * Bit 15 ist Bit 0 usw.
rts

codmovep:
 bsr checkwl                    * Als Gre nur Wort oder Langwort
 bsr checkdn                    * Kommt Datenregister am Anfang ?
 bcs.s cod1movep                * Nein, dann weiter
 ror #7,d5                      * An richtige Stelle
 or d5,d6                       * Verknpfen
 cmp #1,wordbyte(a5)            * Wort-Gre ?
 beq.s cod12mp                  * Ja, dann weiter
 or #%111000000,d6              * Gre einbauen
bra.s cod13mp
cod12mp:
 or #%110000000,d6              * Gre fr Wort
cod13mp:
 bsr kommack                    * Komma mu folgen
 bsr getea                      * Adressmode holen
 move d2,d1
 and #%111000,d2                * Adressierungsart testen
 cmp #%101000,d2                * Ist es d(an)
 bsr errnadress                 * Nein, dann Fehler
 and #7,d1                      * Nur Registernummer behalten
 exg d0,d1
 or d6,d0                       * Verknpfen mit Befehlscode
 bsr putword                    * Ausgabe Befehlscode
 exg d0,d1
 bsr rangewck                   * Mu Wort-Bereich sein
bra putword                     * Ausgabe

cod1movep:
 bsr getea                      * Adressmode holen
 move d2,d1
 and #%111000,d2
 cmp #%101000,d2                * Mu d(an) sein
 bsr errnadress                 * Sonst Fehler
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann mu Datenregister kommen
 bsr errcsyntax                 * Fehlertest
 ror #7,d5                      * Nummer an richtige Stelle
 or d6,d5                       * Verknpfen
 and #7,d1
 or d5,d1
 cmp #1,wordbyte(a5)            * Wort als Gre, dann weiter
 beq.s cod2mp
 or #%101000000,d1              * Bits fr Langwort
bra.s cod3mp
cod2mp:
 or #%100000000,d1              * Bits fr Wort
cod3mp:
 exg d0,d1
 bsr putword                    * Ausgabe Befehlscode
 exg d0,d1
 bsr rangewck                   * Bereichstest
bra putword                     * Ausgabe

codmoveq:
 bsr checkl                     * Als Gre nur Langwort
 bsr immeck                     * '#' mu am Anfang stehen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 bsr expr1                      * Wert holen
 bsr kommack                    * Komma mu folgen
 bsr checkdn                    * Dann Datenregister
 bsr errcsyntax                 * Fehlerabfrage
 ror #7,d5                      * Nummer an richtige Stelle
 or d6,d5                       * Verknpfen
 bsr rangebck                   * Bereichtstest
 and #$ff,d0                    * Nur Byte
 or d5,d0                       * Verknpfen
bra putword                     * Ausgabe

codmoves:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr sizeein                    * Gre an richtige Stelle
 bsr getadda                    * Register am Anfang ?
 bcs.s codmovs0                 * Nein, dann weiter
 or #$0800,d5                   * Richtung
 move d5,-(a7)                  * Merken
 bsr kommack                    * Komma mu folgen
 bsr getea
 and #dreg!areg!pcadr,d4        * Falsche Adressierungsarten
 bsr errnadress
 bsr putorea                    * Ausgabe Befehl
 move.l d0,d7                   * d0 merken
 move (a7)+,d0
 bsr putword                    * Ausgabe Quellregister
 move.l d7,d0
bra putea                       * Ausgabe Erweiterung

codmovs0:
 bsr getea                      * Adressierungsart holen
 and #dreg!areg!pcadr,d4        * Falsche Adreesierungsarten
 bsr errnadress                 * Fehler
 bsr putorea                    * Ausgabe
 move.l d0,d7
 bsr kommack                    * Komma mu folgen
 bsr getadda                    * Register holen
 bsr errcsyntax                 * Fehler
 move d5,d0
 bsr putword                    * Ausgabe Register
 move.l d7,d0
bra putea                       * Ausgabe Erweiterung

codneg:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr sizeein                    * Gre an richtige Stelle
bra codtas1                     * Weiter wie TAS

codstop:
 bsr checkno                    * Keine Grenangabe erlaubt
 bsr.s immeck                   * '#' mu am Anfang vorhanden sein
 bsr errcsyntax                 * Sonst Fehlerausgabe
 move d6,d0
 bsr putword                    * Ausgabe Befehlscode
 bsr expr1                      * Wert ermitteln
 bsr rangewck                   * Mu Wort-Bereich sein
bra putword                     * Ausgabe

codswap:
 bsr checkw                     * Nur Wort als Gre
 bsr checkdn                    * Datenregister am Anfang ?
bra.s codunlk0                  * Ausgabe

codtrap:
 bsr checkno                    * Ohne Gre
 bsr.s immeck                   * '#' mu folgen
 bsr errcsyntax                 * Sonst Fehlerausgabe
 bsr expr1                      * Wert holen
 cmp #$10,d0                    * Bereich 0..$f erlaubt
 bls.s codtrap1                 * OK
 bsr errb1                      * Wertebereich falsch
 and #$f,d0                     * Bereich einschrnken
codtrap1:
 or d6,d0                       * Verknpfen
bra putword                     * Ausgabe

codunlk:
 bsr checkno                    * Ohne Gre
 bsr checkan                    * Adressregister mu folgen
codunlk0:
 bsr errcsyntax                 * Sonst Fehlerausgabe
 or d6,d5                       * Verknpfen
 move d5,d0                     * Und nach d0
bra putword                     * Fr Ausgabe

immeck:
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #'#',(a0)                * Folgt '#' ?
 bne carset                     * Nein, dann Carry setzen
 addq.l #1,a0                   * Sonst a0 erhhen
bra carres                      * Und Carry rcksetzen

symclr:
 cmp #1,passflag(a5)            * Nur im ersten Durchlauf erlaubt
 bne.s symclrfi
 move.l a0,d0                   * a0 darf nicht zerstrt werden
 bsr symloesche                 * Symboltabelle lschen
 movea.l d0,a0
symclrfi:
rts

coddc:
 bsr checkbwl                   * Alle Gren erlaubt
 tst wordbyte(a5)               * Byte ?
 bne.s coddcw                   * Nein, dann weiter
coddcb:
 bsr igbn                       * Leerzeichen ignorieren
 cmp.b #$27,(a0)+               * ' = Anfang Text
 beq.s coddcbtxt
 subq.l #1,a0                   * Sonst a0 zurck
 bsr expr1                      * Wert holen
 bsr rangebck                   * Mu Byte-Bereich sein
 bsr putbyte                    * Ausgeben
coddcb1:
 bsr igbn
 cmp.b #',',(a0)+               * Komma kann folgen
 beq.s coddcb                   * OK, wiederholen
 subq.l #1,a0                   * Ende
rts

coddcbtxt:
 cmp.b #$27,(a0)+               * ' = Ende Text
 beq.s coddcb1
 cmp.b #' ',-(a0)               * Mu ASCII-Zeichen sein
 bsr errcsyntax
 move.b (a0)+,d0                * Holen
 bsr putobyte                   * Und ausgeben
bra.s coddcbtxt                 * Wiederholen

coddcw:
 cmp #1,wordbyte(a5)            * Wort-Gre
 bne.s coddcl                   * Nein, dann weiter
coddcw1:
 bsr expr1                      * Wert holen
 bsr rangewck                   * Mu Wort-Bereich sein
 bsr putword                    * Ausgabe
 bsr igbn
 cmp.b #',',(a0)+               * Komma kann folgen
 beq.s coddcw1                  * OK, wiederholen
 subq.l #1,a0                   * Ende
rts

coddcl:
 bsr expr1                      * Wert holen
 bsr putlong                    * Ausgabe
 bsr igbn
 cmp.b #',',(a0)+               * Komma kann folgen
 beq.s coddcl                   * OK, wiederholen
 subq.l #1,a0                   * Ende
rts

coddf:
 bsr checkbwl                   * Gre holen
 bsr expr1                      * Anzahl der Werte
 tst d1                         * Fehler ?
 beq.s *+8                      * Dann vorsichtshalber nicht weitermachen
 cmp #5,d1
 bne.s *+10                     * OK, auch nicht undefinert
 lea txtdf(pc),a0
bra errabbr                     * Abbruch des Assembliervorgangs
 tst.l d0
 beq errb1                      * Bereichsfehler
 move.l d0,d6
 bsr kommack                    * Komma mu folgen
 bsr expr1                      * Wert holen
 move.l d0,d1
 tst wordbyte(a5)
 bne.s coddf1
coddf0:
 bsr co2test                    * Extraabfrage, da eventuell lngere Schleife
 bcs abbruch                    * Abbruch mit Ctrl-C
 move.l d1,d0
 bsr rangebck                   * Byte, deshalb Bereich testen
 bsr putbyte                    * Byte ausgeben
 subq.l #1,d6
bne.s coddf0                    * Schleife
rts
coddf1:
 cmp #1,wordbyte(a5)
 bne.s coddf3
coddf2:
 bsr co2test                    * Extraabfrage, da eventuell lngere Schleife
 bcs abbruch                    * Abbruch mit Ctrl-C
 move.l d1,d0
 bsr rangewck                   * Wort, deshalb Bereich testen
 bsr putword                    * Wert ausgeben
 subq.l #1,d6                   * Schleife
bne.s coddf2
rts
coddf3:
 bsr co2test                    * Extraabfrage, da eventuell lngere Schleife
 bcs abbruch                    * Abbruch mit Ctrl-C
 move.l d1,d0
 bsr putlong
 subq.l #1,d6
bne.s coddf3
rts

codoff:
 bsr checkno                    * Keine Grenangabe
 bsr expr1                      * Wert holen
 bclr.l #0,d0                   * Mu gerader Wert sein
 bsr errnsyntax                 * Sonst Fehler
 move.l d0,offset(a5)           * Und merken
rts

codds:
 bsr checkbwl                   * Alle Gren erlaubt
 bsr expr1                      * Wert holen
 tst.l d0                       * Wenn Wert Null
 beq.s codadjust                * Dann zu ds 0
 move wordbyte(a5),d1           * Gre holen
 beq.s codds1                   * Byte-Gre ? Dann OK
 add.l d0,d0                    * Wert mal 2
 cmp #1,d1                      * Wort-Gre ?
 beq.s codds1                   * Ja, dann OK
 add.l d0,d0                    * Sonst Wert insgesamt mal 4
codds1:
 add.l d0,pcstand(a5)           * Wert zum PC-Stand addieren
rts

codadjust:
 addq.l #1,pcstand(a5)
 and.b #$fe,pcstand+3(a5)       * Jetzt ist PC immer auf gerader Adresse
rts

codrs:
 move.l rscount(a5),d0          * Zhler
 moveq #3,d1                    * Langwort
 bsr newval                     * Neues Symbol
 bcc.s codrs1                   * OK
 cmp.l datenwert(a3),d0
 bsr errnmult                   * Eventuell mehrfach definiert
 move.l d0,datenwert(a3)        * Auf neuen Wert
 move d1,attribut(a3)           * einstellen
codrs1:
 bsr igbn                       * Leerzeichen ignorieren
 addq.l #2,a0                   * 'RS' berspringen
 movea.l a0,a4                  * Adresse merken
 lea ausbuf(a5),a0
 move #'= ',(a0)+
 bsr print8x                    * Wert des Symbols ausgeben
 move.b #' ',(a0)               * Null berschreiben
 movea.l a4,a0                  * Adresse zurck
 bsr checkbwl                   * Gre holen
 bsr expr1                      * Wert holen
 tst.l d0
 beq.s codrs4
 move wordbyte(a5),d1           * Gre holen
 beq.s codrs3                   * Byte-Gre ? Dann OK
 btst.b #0,rscount+3(a5)
 beq.s codrs2
 addq.l #1,datenwert(a3)        * Auf Wortgrenze bringen
 moveq #5,d7
 bsr errende                    * Nicht auf Wortgrenze
codrs2:
 add.l d0,d0                    * Wert mal 2
 cmp #1,d1                      * Wort-Gre ?
 beq.s codrs3                   * Ja, dann weiter
 add.l d0,d0                    * Sonst Wert insgesamt mal 4
codrs3:
 add.l d0,rscount(a5)           * Wert zum RS-Zhler addieren
bra assline7                    * Restd er Zeile testen

codrsin:                        * Einsprung, wenn RS alleine steht
 addq.l #4,a7                   * Stack reinigen
 bsr checkbwl
 bsr expr1
 tst.l d0
 beq.s codrs4                   * Auf Wortgrenze bringen
 move wordbyte(a5),d1
 beq.s codrs3
bra.s codrs2

codrs4:
 addq.l #1,rscount(a5)
 and.b #$fe,rscount+3(a5)       * RS-Zhler auf gerader Adresse
bra assline7                    * Rest der Zeile testen

codrsreset:
 bsr checkno                    * Keine Grenangabe
 clr.l rscount(a5)              * RS-Zhler zurcksetzen
rts

codrsset:
 bsr checkno                    * Keine Grenangabe
 bsr expr1                      * Wert holen
 tst errflag(a5)
 bne carset                     * Fehler
 move.l d0,rscount(a5)          * Wert merken
rts

codend:
 move #2,errflag(a5)            * Merker fr Ende
rts

codorg:                         * bersetzungsadresse einstellen
 bsr checkno                    * Ohne Grenangabe
 bsr expr1                      * Wert holen
 move.l d0,pcstand(a5)          * Wert einstellen
 movea.l a0,a1                  * a0 merken
 lea ausbuf(a5),a0              * Ziel
 bsr print6x                    * Adresse neu in Zeile setzen
 move.b #' ',(a0)               * Null am Ende berschreiben
 movea.l a1,a0                  * a0 zurck
rts

debugon:
 cmp #2,passflag(a5)            * Nur beim zweiten Durchgang
 bne.s debugfi
 cmp.b #1,debug(a5)             * Debug schon an ?
 beq.s debugfi                  * Ja, dann OK
 st debug(a5)                   * Debug anschalten ( Fr nchste Zeile )
rts

debugoff:                       * Debug ausschalten
 cmp #2,passflag(a5)            * Nur beim zweiten Durchgang
 bne.s debugfi
 clr.b debug(a5)                * Debug aus
debugfi:
rts

ausmode:
 cmp #2,passflag(a5)
 bne carres
 move.b d6,iostat(a5)
rts

***** Fehlerbehandlung *****

range07:                        * Bereichstest 0..7
 cmp #2,passflag(a5)            * Nur beim zweiten Durchgang
 bne.s rangefi
 move.l d0,d7                   * Retten
 and.l #$fffffff8,d7            * Test
 bne.s errb1                    * Nicht im Bereich 0..7
rts

rangeb1ck:                      * Bereich in Byte-Grenze mit Vorzeichen
 cmp #2,passflag(a5)
 bne.s rangefi
 move.l d0,d7
 and.l #$ffffff80,d7
 beq.s rangefi                  * OK
 cmp.l #$ffffff80,d7
 bne.s errb1                    * Fehler
rts

rangebck:                       * Bereich in Byte-Grenze ohne Vorzeichen
 cmp #2,passflag(a5)
 bne.s rangefi
 move.l d0,d7
 and.l #$ffffff00,d7
 beq.s rangefi                  * OK
 cmp.l #$ffffff00,d7
 bne.s errb1                    * Fehler
rts

rangew1ck:                      * Bereich in Wort-Grenze mit Vorzeichen
 cmp #2,passflag(a5)
 bne.s rangefi
 move.l d0,d7
 and.l #$ffff8000,d7
 beq.s rangefi                  * OK
 cmp.l #$ffff8000,d7
 bne.s errb1                    * Fehler
rts

rangewck:                       * Bereich in Wort-Grenze ohne Vorzeichen
 cmp #2,passflag(a5)
 bne.s rangefi
 move.l d0,d7
 and.l #$ffff0000,d7
 beq.s rangefi                  * OK
 cmp.l #$ffff0000,d7
 bne.s errb1                    * Fehler
rangefi:
rts

errb1:                          * Bereichsfehler
 moveq #0,d7
bra.s errende

erreber:
 beq.s errb1                    * Bereichsfehler, wenn gleich
rts

errcber:
 bcs.s errb1                    * Bereichsfehler, wenn Carry gesetzt
rts

errnber:
 bne.s errb1                    * Bereichsfehler, wenn ungleich
rts

errcsyntax:
 bcs.s errs1                    * Syntaxfehler, wenn Carry gesetzt
rts

erresyntax:
 beq.s errs1                    * Syntaxfehler, wenn gleich
rts

errnsyntax:
 bne.s errs1                    * Syntaxfehler, wenn ungleich
rts

errs1:
 moveq #1,d7
bra.s errende                   * Fehlerauswertung

errcadress:
 bcs.s erradr1                  * Adressfehler, wenn Carry gesetzt
rts

erreadress:
 beq.s erradr1                  * Adressfehler, wenn gleich
rts

errnadress:
 bne.s erradr1                  * Adressfehler, wenn ungleich
rts

erradr1:
 moveq #2,d7
bra.s errende                   * Fehlerauswertung

erru1:
 moveq #3,d7
bra.s errende                   * Fehlerauswertung

errnmult:
 beq.s errfi                    * Mehrfach definiert, wenn ungleich
 moveq #4,d7
bra.s errende

erresize:
 beq.s errsize                  * Falsche Gre, wenn gleich
rts

errnsize:
 bne.s errsize                  * Falsche Gre, wenn ungleich
rts

errsize:
 moveq #6,d7

errende:
 tst errflag(a5)                * Schon Fehler vorhanden ?
 bne.s errfi                    * Ja, Ende
 move d7,errart(a5)             * Fehlerart merken
 move #1,errflag(a5)            * Anzeige, da Fehler vorhanden
 move.l a0,errpoi(a5)           * Zeiger auf Fehler
 addq #1,errcnt(a5)             * Ein Fehler mehr vorhanden
errfi:
rts

errtab:
 dc.w txtber-errtab             * Bereichsfehler
 dc.w txtsyn-errtab             * Syntaxfehler
 dc.w txtadr-errtab             * Adressfehler
 dc.w txtundef-errtab           * Undefiniert
 dc.w txtmult-errtab            * Mehrfach definiert
 dc.w txtadj-errtab             * Nicht auf Wortgrenze
 dc.w txtsize-errtab            * Falsche Grenangabe

erranalyse:                     * Fehlerausgabe
 bsr newput                     * Ausgabe letzte Zeile
 move errart(a5),d0             * Art des Fehlers
 add d0,d0                      * Mal zwei
 move errtab(pc,d0),d0          * Adresse Fehlertext
 lea errtab(pc,d0),a0           * Berechnen
 move.l errpoi(a5),d1           * Zeiger auf Fehlerstelle
 lea einbuf-insst(a5),a1        * Anzahl der '-' berechnen
 sub.l a1,d1
 and #$ff,d1                    * Maximal 255
erran1:
 moveq #'-',d0                  * '-' ausgeben
 bsr co2ausa
dbra d1,erran1
 moveq #'^',d0                  * Dann '^' als Zeiger
 bsr co2ausa
 bsr crlfe                      * CR LF
 bsr prtco2                     * Ausgabe des Fehlertextes
bra crlfe                       * CR LF

errabbr:                        * Abbruch mit Fehlerausgabe
 move #2,passflag(a5)           * Ausgabe anschalten
 bsr prtco2                     * Text ausgeben
 bsr crlfe                      * Zeilenvorschub

abbruch:
 movea.l a6,a7                  * Stack zurck
 move #2,passflag(a5)           * Zweiter Durchgang, damit CO2 an
 move #2,errflag(a5)            * CO2 wirklich Ausgabe an
 lea txtend(pc),a0
 bsr prtco2                     * Ende-Text
 moveq #'0',d0
 bsr esc7                       * Immer Software-Scroll an
 addq #1,errcnt(a5)             * Ein Fehler mehr, als Merker fr Abbruch
 move.b (a7)+,cotempo(a5)       * Fr sptere Ausgaben wieder alte Scrollart
bra carset                      * Assembliervorgang abgebrochen

txtber:
 dc.b 'Wertebereich falsch',0

txtsyn:
 dc.b 'Syntax Fehler',0

txtadr:
 dc.b 'Adressmode nicht erlaubt',0

txtundef:
 dc.b 'Undefiniertes Symbol',0

txtmult:
 dc.b 'Mehrfach Definiert',0

txtadj:
 dc.b 'Nicht auf Wortgrenze',0

txtsize:
 dc.b 'Grenangabe nicht erlaubt',0

txtmacro:
 dc.b 'MACRO nicht beendet !!!',0

txtdf:
 dc.b 'Fehler in DF-Anweisung !!!',0

txtend:
 dc.b $d,$a,'Abbruch des Assembliervorgangs !!!',$d,$a,0

ds 0
                                                                                                                                                                                                                                                                                                                                                                                          $!`*	 $R  ̋:$	
 (
h@A  ))Ì~ JvA,@L 
Q'YodiA#`,	RD)2'!0F
G@.$U)D@" `9Q cCŇ .!<nB  @-
HJ %nJ
)dl
 
 2! PI&ʄBqpd `

  ~k!@B"*$®(n `" 1 @"@) @Q
8, KH0EB0!E`  @%`SJi @FH$ F9G *&K(*
:#
#P=!QP@ .)  83dP `MMH#x` aj E   ڻ1 H $@Ї
@RZOa0e		